/*
 * QrfeRfeUpdateController.h
 *
 *  Created on: 01.07.2010
 *      Author: stefan.detter
 */

#ifndef QRFERFEUPDATECONTROLLER_H_
#define QRFERFEUPDATECONTROLLER_H_

#include <QObject>
#include <QFileInfo>

#include <QrfeTraceModule>
#include <QrfeReaderInterfaceGlobal>

class QrfeRfeReader;

class QrfeRfeUpdateController : public QObject, QrfeTraceModule
{
	Q_OBJECT

public:
	typedef enum{
		UPDATE_OK,
		UPDATE_FILE_NOT_OPENED,
		UPDATE_FILE_NOT_VALID,
		UPDATE_FAILED,
		UPDATE_STOPED,
	}UpdateResult;

	QrfeRfeUpdateController(QrfeRfeReader* reader, QObject* parent = 0);
	virtual ~QrfeRfeUpdateController();

public:
    QrfeGlobal::Result     clearLicense();

	UpdateResult updateReader(const QFileInfo& imageFile);
	UpdateResult updateReader(const ulong hwRev, const ulong swRev, const ulong readerTyp, const QFileInfo& imageFile);
	UpdateResult updateReader(const QByteArray firmwareInfo, const QByteArray& imageData);

	void stopCurrentUpdate();

signals:
	void progressChanged(int cur, int max);

private:
	QrfeRfeReader*		m_reader;
	bool				m_runUpdate;

public:
	static uint 		_traceLevel;
};

#endif /* QRFERFEUPDATECONTROLLER_H_ */
